/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.hooks;

import com.gjhi.tinkersinnovation.contexts.BombExplodeContext;
import com.gjhi.tinkersinnovation.library.entitys.entitys.tinker_bomb.EBomb;
import com.gjhi.tinkersinnovation.register.TinkersInnovationUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public interface TinkersBombHook {
    default public void onTinkersBombExplosion(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, EBomb bomb, LivingEntity attacker, BombExplodeContext context) {
    }

    default public void afterTinkersBombExplode(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, EBomb bomb, LivingEntity attacker, List<LivingEntity> targets) {
    }

    default public void beforeBombPiecesHit(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, EBomb bomb, LivingEntity attacker, List<LivingEntity> targets, Map<LivingEntity, Integer> hitted) {
    }

    default public void afterBombPiecesHit(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, EBomb bomb, LivingEntity attacker, LivingEntity target, int hitcount) {
    }

    public static void pieceHitting(Map<LivingEntity, Integer> hitted, List<LivingEntity> targets, int count) {
        for (int i = 0; i < count; ++i) {
            LivingEntity entity = TinkersInnovationUtils.getRandomInList(targets);
            if (entity == null) continue;
            hitted.put(entity, hitted.getOrDefault(entity, 0) + 1);
        }
    }

    public record AllMerger(Collection<TinkersBombHook> modules) implements TinkersBombHook
    {
        @Override
        public void onTinkersBombExplosion(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, EBomb bomb, LivingEntity attacker, BombExplodeContext context) {
            for (TinkersBombHook module : this.modules) {
                module.onTinkersBombExplosion(modifiers, persistentData, modifier, bomb, attacker, context);
            }
        }

        @Override
        public void afterTinkersBombExplode(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, EBomb bomb, LivingEntity attacker, List<LivingEntity> targets) {
            for (TinkersBombHook module : this.modules) {
                module.afterTinkersBombExplode(modifiers, persistentData, modifier, bomb, attacker, targets);
            }
        }

        @Override
        public void beforeBombPiecesHit(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, EBomb bomb, LivingEntity attacker, List<LivingEntity> targets, Map<LivingEntity, Integer> hitted) {
            for (TinkersBombHook module : this.modules) {
                module.beforeBombPiecesHit(modifiers, persistentData, modifier, bomb, attacker, targets, hitted);
            }
        }

        @Override
        public void afterBombPiecesHit(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, EBomb bomb, LivingEntity attacker, LivingEntity target, int hitcount) {
            for (TinkersBombHook module : this.modules) {
                module.afterBombPiecesHit(modifiers, persistentData, modifier, bomb, attacker, target, hitcount);
            }
        }
    }
}

